<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePositionTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('position')) {
            Schema::create('position', function (Blueprint $table) {
                $table->bigIncrements('id');
				$table->string('name')->nullable();
				$table->integer('level')->nullable();
				$table->string('register_form')->nullable();
				$table->string('accept_form')->nullable();
				$table->string('edit_form')->nullable();
				$table->string('cancel_form')->nullable();
				$table->integer('status')->nullable();
				$table->string('description')->nullable();
				$table->integer('user_id')->nullable();
				$table->integer('company_id')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('position');
    }
}
