<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTempMembersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('temp_members')) {
            Schema::create('temp_members', function (Blueprint $table) {
                $table->bigIncrements('id');
				$table->integer('code')->nullable();
				$table->string('ref_no')->nullable();
				$table->string('payable_id')->nullable();
				$table->string('receivable_id')->nullable();
				$table->string('name');
				$table->string('father_name')->nullable();
				$table->string('phone')->nullable();
				$table->string('price_level_id')->nullable();
				$table->string('type')->nullable();
				$table->string('description')->nullable();
				$table->string('class_id')->nullable();
				$table->string('gender')->nullable();
				$table->string('address')->nullable();
				$table->string('opening_type')->nullable();
				$table->string('currency')->nullable();
				$table->double('amount')->nullable();
				$table->integer('company_id')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('temp_members');
    }
}
