<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

class CreateChangeTableEngine extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		$tables = array(
            'adjustments', 'adjustment_details', 'adjustment_stock_outs', 'adjustment_transaction_details',
            'attendances', 'attendance_sheets', 'audits', 'bank_check', 'bank_checks', 'bills', 'bill_payments', 'branch_transfers',
            'branch_transfer_details', 'builds', 'build_details', 'build_expenses', 'build_infos', 'build_stock_ins', 'build_stock_outs', 'contracts',
            'contract_closes', 'contract_close_details', 'contract_details', 'contract_expense_purchases', 'contract_purchases', 'contract_shareholders', 'contract_stocks',
            'currency_rate_details', 'daily_expenses', 'deliveries', 'delivery_details', 'delivery_stock_outs', 'employee_payroll_taxes', 'drawings', 'expenses', 'expense_details', 'fined_drivers', 'general_infos', 'gifts',
            'glasses', 'information_to_updates', 'inventory_receives', 'inventory_transfers', 'inventory_transfer_details', 'inventory_transfer_infos', 'invoices', 'invoice_payments',
            'item_expenses', 'item_expense_details', 'item_expense_outs', 'item_none_costs', 'item_none_cost_details', 'journal_entries', 'journal_entry_details', 'loadings',
            'loading_details', 'loans', 'main_stocks', 'member_journals', 'member_opening_balances', 'member_transactions', 'member_transfers', 'm_stocks_in',
            'm_stocks_out', 'opening_inventories', 'opening_stocks', 'other_builds',
            'overtimes', 'packages', 'package_details', 'password_resets', 'payments', 'payment_by_factors', 'payment_by_factor_details', 'payrolls',
            'payroll_forms', 'projects', 'project_builds', 'project_build_items', 'project_closes', 'project_close_details', 'project_details', 'project_expenses',
            'project_expense_details', 'project_finishes', 'project_items', 'project_item_transactions', 'project_services', 'project_shareholders', 'project_stocks', 'project_stock_outs',
            'project_transactions', 'project_wastages', 'purchases', 'purchase_discounts', 'purchase_infos', 'purchase_orders', 'purchase_order_details', 'purchase_order_payments',
            'purchase_order_records', 'purchase_payments', 'purchase_transactions', 'receipts',
            'receivable_payments', 'receive_by_factors', 'receive_by_factor_details', 'recipes', 'recipe_details', 'recipe_operators', 'refunds', 'refund_return_payments',
            'refund_return_transactions', 'refund_stocks', 'rents', 'return_backs', 'return_refund_details', 'return_stock_outs', 'sales', 'sales_orders',
            'sales_order_details', 'sales_order_records', 'sale_by_type_details', 'sale_details',
            'sale_infos', 'sale_items', 'sale_order_receives', 'sale_order_services', 'sale_payments', 'sale_receives', 'sale_services', 'sale_taxations',
            'sale_transactions', 'send_moneys', 'stocks', 'stock_outs', 'stucks', 'system_alerts', 'transactions', 'transfers', 'transfer_accounts', 'transfer_and_loadings', 'transfer_details', 'vehicle_expenses',
            'vehicle_expenses_details', 'vehicle_fixes', 'vehicle_fix_details', 'vehicle_locations','vehicle_managements', 'vehicle_receives', 'member_exchanges', 'temp_form_detail', 'temp_form', 'member_cloth_details',
            'member_cloths', 'add_stock_details', 'add_stocks', 'sale_discount_date', 'selected_dropdown','contract_farmer_details', 'member_guarantor', 'contract_farmer',
            'accounts', 'adjustment_categories', 'advance_pricing_details', 'advance_pricings', 'amount_formats',
            'assemblies', 'assembly_expenses', 'attachment_categories', 'attachments', 'attendance_types', 'auto_backups', 'close_year_accounts', 'close_year_member_statements', 'close_year_stocks', 'close_years',
            'close_years_equity', 'cloth_categories', 'cloth_properties', 'cloth_style_details', 'cloth_styles',
			'companies', 'company_contacts', 'company_details', 'company_infos', 'cost_for_customers', 'costs', 'currencies', 'custome_reports', 'drivers', 'employee_attendance_classes', 
			'expense_categories', 'factor_designs', 'formulas', 'group_company_settings', 'home_currencies', 'inventories', 'inventory_brand', 'inventory_categories', 'inventory_min_maxes',
			'item_ex_categories_list', 'item_expense_categories', 'item_type_payrolls', 'items', 'job_titles', 'lang_translates', 'last_close_year', 'last_year', 'leave_types', 'lives',
			'measure_units', 'member_classes', 'member_cloth_styles', 'member_informations', 'member_job_titles', 'member_member_type', 'member_payable_levels', 'member_typs', 'members', 'menu_columns', 
			'menus', 'migrations', 'new_custom_reports', 'note_details', 'notes', 'online_order_records', 'overtime_types', 'payroll_price_level_details', 'payroll_price_levels', 'payroll_tax_details', 
			'payroll_taxes', 'permission_groups', 'permission_permission_group', 'permission_role', 'permissions', 'price_level_details', 'price_levels', 'products',
			'project_categories', 'project_progresses', 'quantities', 'role_user', 'roles', 's_products', 'salary_details', 'sale_areas', 'service_classes', 'measure_exchanges',
			'system_configs', 'taxations', 'temp_items', 'transport_companies', 'transports', 'users', 'vehicle_equipment', 'vehicle_types', 'vehicles', 'work_types', 'inventory_sites', 'machines'
			
        );
		foreach($tables as $val){
			if(Schema::hasTable($val)) {
			DB::statement('ALTER TABLE '. $val .' ENGINE = InnoDB');
			}
		}				
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        
    }
}
