<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateContractFarmerDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('contract_farmer_details')) {
            Schema::create('contract_farmer_details', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->integer('contract_farmer_id');
				$table->string('type')->nullable();
				$table->string('number')->nullable();
                $table->string('ref_no')->nullable();
				$table->datetime('date')->nullable();
                $table->text('purchase_description')->nullable();
                $table->string('currency')->nullable();
                $table->double('rate')->nullable();
                $table->string('status')->nullable();
                $table->integer('inventory_id')->nullable();
                $table->double('quantity')->nullable();
                $table->integer('measure_id')->nullable();
                $table->double('cost')->nullable();
                $table->integer('purchase_id')->nullable();
                $table->integer('purchase_info_id')->nullable();
				$table->integer('user_id')->nullable();
                $table->integer('company_id')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('contract_farmer_details');
    }
}
