<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMemberGuarantorTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('member_guarantor')) {
            Schema::create('member_guarantor', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->integer('member_id');
				$table->string('name')->nullable();
				$table->string('father_name')->nullable();
				$table->string('phone')->nullable();
				$table->string('photo')->nullable();
				$table->string('address')->nullable();
				$table->string('country')->nullable();
				$table->string('city')->nullable();
				$table->string('district')->nullable();
                $table->string('village')->nullable();
				$table->integer('user_id')->nullable();
                $table->integer('company_id')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('member_guarantor');
    }
}
