<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateContractFarmerTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('contract_farmer')) {
            Schema::create('contract_farmer', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->integer('member_id');
				$table->string('number')->nullable();
                $table->string('ref_no')->nullable();
				$table->datetime('date')->nullable();
                $table->text('sale_description')->nullable();
                $table->string('currency')->nullable();
                $table->double('rate')->nullable();
                $table->string('status')->nullable();
				$table->datetime('overdue_date')->nullable();
				$table->string('alert_status')->nullable();
                $table->string('land_size')->nullable();
                $table->integer('land_drawing_measure')->nullable();
                $table->double('land_drawing_amount')->nullable();
                $table->double('seed_amount')->nullable();
                $table->integer('measure_id')->nullable();
                $table->integer('sale_id')->nullable();
				$table->integer('user_id')->nullable();
                $table->integer('company_id')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('contract_farmer');
    }
}
