<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMemberExchangesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('member_exchanges')) {
            Schema::create('member_exchanges', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->string('type');
				$table->string('number')->nullable();
                $table->string('ref_no')->nullable();
                $table->integer('member_id')->nullable();
				$table->datetime('date')->nullable();
                $table->text('description')->nullable();
                $table->string('payable_currency')->nullable();
                $table->double('payable_amount')->nullable();
                $table->double('payable_rate')->nullable();
				$table->integer('payable_tran_id')->nullable();
                $table->string('receivable_currency')->nullable();
                $table->double('receivable_amount')->nullable();
                $table->double('receivable_rate')->nullable();
				$table->integer('receivable_tran_id')->nullable();
				$table->integer('user_id')->nullable();
                $table->integer('company_id')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('member_exchanges');
    }
}
