<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTempFormDetailTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('temp_form_detail')) {
            Schema::create('temp_form_detail', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->integer('temp_form_id');
				$table->string('type');
                $table->integer('inventory_id')->nullable();
                $table->integer('site_id')->nullable();
                $table->integer('um_id')->nullable();
				$table->double('cost')->nullable();
				$table->double('qty')->nullable();
                $table->string('description')->nullable();
                $table->string('description2')->nullable();
                $table->string('other_measure')->nullable();
                $table->string('other_measure2')->nullable();
				$table->integer('inventory_category_id')->nullable();
				$table->integer('contract_id')->nullable();
				$table->double('discount')->nullable();
				$table->integer('sale_order_detail_id')->nullable();
				$table->integer('um1_id')->nullable();
				$table->integer('um2_id')->nullable();
				$table->integer('um3_id')->nullable();
                $table->string('item_type')->nullable();
				$table->double('oil_qty')->nullable();
				$table->double('density')->nullable();
				$table->integer('loading_detail_id')->nullable();
				$table->integer('row_taxation_id')->nullable();
                $table->string('row_tax_percent')->nullable();
                $table->string('row_tax_stat')->nullable();
                $table->string('driver_name')->nullable();
                $table->string('vehicle_name')->nullable();
                $table->string('wagon_number')->nullable();
				$table->integer('price_level_id')->nullable();
                $table->string('sub_total_stat')->nullable();
				$table->integer('online_order_detail_id')->nullable();
                $table->timestamps();
            });
        } 
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('temp_form_detail');
    }
}
