<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTempFormTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('temp_form')) {
            Schema::create('temp_form', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->string('type');
				$table->string('number')->nullable();
                $table->string('ref_no')->nullable();
                $table->integer('member_id')->nullable();
				$table->string('date')->nullable();
                $table->text('description')->nullable();
                $table->string('currency')->nullable();
                $table->double('rate')->nullable();
                $table->double('hq_rate')->nullable();
                $table->string('discount_type')->nullable();
                $table->double('discount')->nullable();
                $table->string('status')->nullable();
				$table->string('overdue_date')->nullable();
				$table->string('alert_date')->nullable();
                $table->text('alert_description')->nullable();
                $table->integer('class_id')->nullable();
                $table->integer('sale_area_id')->nullable();
                $table->integer('driver_id')->nullable();
                $table->string('sale_type')->nullable();
                $table->string('other_member_name')->nullable();
                $table->string('oil')->nullable();
				$table->integer('taxation_id')->nullable();
                $table->string('tax_percent')->nullable();
                $table->string('alert_status')->nullable();
                $table->string('sale_taxation')->nullable();
                $table->text('print_description')->nullable();
                $table->string('hesab_sabeqa')->nullable();
				$table->integer('price_level_id')->nullable();
                $table->string('per_qty')->nullable();
                $table->string('contract_check')->nullable();
                $table->string('sale_base_currency')->nullable();
				$table->integer('user_id')->nullable();
                $table->integer('company_id')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('temp_form');
    }
}
