<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMessagesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::connection('mysqlOnline')->hasTable('messages')) {
			Schema::connection('mysqlOnline')->create('messages',function(Blueprint $table){
				$table->bigIncrements('id');
				$table->integer('session_id');
				$table->integer('user_in_id')->nullable();
				$table->integer('user_out_id')->nullable();
				$table->text('massage')->nullable();
				$table->string('status')->nullable();
				$table->string('type')->nullable();
				$table->datetime('date')->nullable();
				$table->timestamps();
			});
		}
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
		Schema::connection('mysqlOnline')->drop('messages');
    }
}
