<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateOnlineInfoSocial extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::connection('mysqlOnline')->hasTable('online_info_social')) {
			Schema::connection('mysqlOnline')->create('online_info_social',function(Blueprint $table){
				$table->bigIncrements('id');
				$table->integer('system_config_id');
				$table->string('social_name')->nullable();
				$table->string('social_url')->nullable();
				$table->string('social_icon')->nullable();
				$table->timestamps();
			});
		}
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
		Schema::connection('mysqlOnline')->drop('online_info_social');
    }
}
