<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateOnlineInfoDetails extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::connection('mysqlOnline')->hasTable('online_info_details')) {
			Schema::connection('mysqlOnline')->create('online_info_details',function(Blueprint $table){
				$table->bigIncrements('id');
				$table->integer('system_config_id');
				$table->string('title')->nullable();
				$table->text('description')->nullable();
				$table->string('image')->nullable();
				$table->timestamps();
			});
		}
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
		Schema::connection('mysqlOnline')->drop('online_info_details');
    }
}
