<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateOnlineOrdersItemTable extends Migration
{
	 /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::connection('mysqlOnline')->hasTable('online_orders_item')) {
			Schema::connection('mysqlOnline')->create('online_orders_item',function(Blueprint $table){
				$table->bigIncrements('id');
				$table->integer('item_id');
				$table->integer('session_id')->nullable();
				$table->integer('user_id')->nullable();
				$table->double('quantity')->nullable();
				$table->timestamps();
			});
		}
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
		Schema::connection('mysqlOnline')->drop('online_orders_item');
    }
	
}
