<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateItemExCategoriesListTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('item_ex_categories_list')) {
			Schema::create('item_ex_categories_list', function (Blueprint $table) {
				$table->bigIncrements('id');
				$table->integer('item_expense_id')->nullable();
				$table->integer('item_expense_category_id')->nullable();
				$table->string('category');
				$table->double('amount');
				$table->integer('company_id')->nullable();
				$table->integer('user_id')->nullable();
				$table->timestamps();
			});
		}
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('item_ex_categories_list');
    }
}
