<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateOnlineCommentTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::connection('mysqlOnline')->hasTable('online_comment')) {
			Schema::connection('mysqlOnline')->create('online_comment',function(Blueprint $table){
				$table->bigIncrements('id');
				$table->integer('online_item_id')->nullable();
				$table->string('user_name')->nullable();
				$table->string('email')->nullable();
				$table->text('description')->nullable();
				$table->integer('parent_id')->nullable();
				$table->integer('like')->nullable();
				$table->string('status')->nullable();
				$table->string('category')->nullable();
				$table->integer('company_id')->nullable();
				$table->timestamps();
			});
		}
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
		Schema::connection('mysqlOnline')->drop('online_comment');
    }
}
