<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMemberClothDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        if(!Schema::hasTable('member_cloth_details')) {
            Schema::create('member_cloth_details', function (Blueprint $table) {
                $table->bigIncrements('id');
				$table->string('size')->nullable();
				$table->string('description')->nullable();
                $table->integer('member_cloth_id')->nullable();
                $table->integer('cloth_category_id')->nullable();
                $table->integer('cloth_property_id')->nullable();
				$table->integer('user_id')->unsigned()->nullable();
                $table->integer('company_id')->unsigned()->nullable();
                $table->timestamps();
            });
        }

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('member_cloth_details');
    }
}
