<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateOnlineItemToShowesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::connection('mysqlOnline')->hasTable('online_item_to_showes')) {
			Schema::connection('mysqlOnline')->create('online_item_to_showes',function(Blueprint $table){
				$table->bigIncrements('id');
				$table->integer('online_item_id');
				$table->string('type');
				$table->string('description')->nullable();
				$table->integer('company_id')->nullable();
				$table->timestamps();
			});
		}
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
		Schema::connection('mysqlOnline')->drop('online_item_to_showes');
    }
}
