<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateOnlineImagesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::connection('mysqlOnline')->hasTable('online_images')) {
			Schema::connection('mysqlOnline')->create('online_images',function(Blueprint $table){
				$table->bigIncrements('id');
				$table->integer('online_item_id');
				$table->string('source');
				$table->string('description')->nullable();
				$table->string('type')->nullable();
				$table->integer('item_to_show_id')->nullable();
				$table->integer('company_id')->nullable();
				$table->timestamps();
			});
		}
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
		Schema::connection('mysqlOnline')->drop('online_images');
    }
}
