<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAddStockDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('add_stock_details')) {
			Schema::create('add_stock_details', function (Blueprint $table) {
				$table->bigIncrements('id');
				$table->integer('add_stock_id')->nullable();
				$table->integer('inventory_id')->nullable();
				$table->double('quantity')->nullable();
				$table->integer('stock_id')->nullable();
				$table->integer('asset_tran')->nullable();
				$table->integer('cost_tran')->nullable();
				$table->string('description')->nullable();
				$table->integer('company_id')->nullable();
				$table->integer('user_id')->nullable();
				$table->timestamps();
			});
		}
		
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('add_stock_details');
    }
}
