<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateOnlineOrderRecordsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::connection('mysqlOnline')->hasTable('online_order_records')) {
			Schema::connection('mysqlOnline')->create('online_order_records',function(Blueprint $table){
				$table->bigIncrements('id');
				$table->integer('order_id');
				$table->integer('order_detail_id')->nullable();
				$table->integer('stock_out_id')->nullable();
				$table->integer('m_stock_out_id')->nullable();
				$table->double('out_bundl')->nullable();
				$table->integer('company_id')->nullable();
				$table->timestamps();
			});
		}
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
		Schema::connection('mysqlOnline')->drop('online_order_records');
    }
}
