<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateOnlineSystemConfigTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::connection('mysqlOnline')->hasTable('online_system_config')) {
			Schema::connection('mysqlOnline')->create('online_system_config',function(Blueprint $table){
				$table->bigIncrements('id');
				$table->string('company_name');
				$table->string('logo')->nullable();
				$table->string('lang')->nullable();
				$table->string('phone')->nullable();
				$table->string('email')->nullable();
				$table->string('website')->nullable();
				$table->string('country')->nullable();
				$table->string('city')->nullable();
				$table->string('street_address')->nullable();
				$table->string('description')->nullable();
				$table->integer('company_id')->nullable();
				$table->timestamps();
			});
		}
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
		Schema::connection('mysqlOnline')->drop('online_system_config');
    }
}
