<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateOnlineOrderTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::connection('mysqlOnline')->hasTable('online_order')) {
			Schema::connection('mysqlOnline')->create('online_order',function(Blueprint $table){
				$table->bigIncrements('id');
				$table->integer('user_id');
				$table->integer('number');
				$table->string('currency')->nullable();
				$table->double('rate')->nullable();
				$table->string('description')->nullable();
				$table->datetime('date')->nullable();
				$table->datetime('delivery_date')->nullable();
				$table->string('type')->nullable();
				$table->string('status')->nullable();
				$table->string('alert_status')->nullable();
				$table->integer('company_id')->nullable();
				$table->timestamps();
			});
		}
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
		Schema::connection('mysqlOnline')->drop('online_order');
    }
}
