<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateOnlineUserTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::connection('mysqlOnline')->hasTable('online_user')) {
			Schema::connection('mysqlOnline')->create('online_user',function(Blueprint $table){
				$table->bigIncrements('id');
				$table->string('fname');
				$table->string('lname')->nullable();
				$table->string('email')->nullable();
				$table->string('password')->nullable();
				$table->string('lang')->nullable();
				$table->string('photo')->nullable();
				$table->string('type')->nullable();
				$table->string('status')->nullable();
				$table->integer('company_id')->nullable();
				$table->timestamps();
			});
		}
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
		Schema::connection('mysqlOnline')->drop('online_user');
    }
}
