<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateOnlineItemTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::connection('mysqlOnline')->hasTable('online_item')) {
			Schema::connection('mysqlOnline')->create('online_item',function(Blueprint $table){
				$table->bigIncrements('id');
				$table->integer('item_id');
				$table->string('name')->nullable();
				$table->double('price')->nullable();
				$table->double('onhand')->nullable();
				$table->string('color')->nullable();
				$table->datetime('collection')->nullable();
				$table->string('category_id')->nullable();
				$table->string('brand_id')->nullable();
				$table->string('um_id')->nullable();
				$table->string('currency')->nullable();
				$table->string('description')->nullable();
				$table->string('image')->nullable();
				$table->string('type')->nullable();
				$table->integer('company_id')->nullable();
				$table->integer('user_id')->nullable();
				$table->timestamps();
			});
		}
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
		Schema::connection('mysqlOnline')->drop('online_item');
    }
}
