<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSaleDiscountDateTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('sale_discount_date')) {
			Schema::create('sale_discount_date', function (Blueprint $table) {
				$table->bigIncrements('id');
				$table->string('name');
				$table->integer('days')->nullable();
				$table->integer('discount')->nullable();
				$table->string('description');
				$table->integer('company_id')->nullable();
				$table->integer('user_id')->nullable();
				$table->timestamps();
			});
		}
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sale_discount_date');
    }
}
