<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSelectedDropdownTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('selected_dropdown')) {
			Schema::create('selected_dropdown', function (Blueprint $table) {
				$table->bigIncrements('id');
				$table->string('form');
				$table->string('dropdown');
				$table->integer('selected_id')->nullable();
				$table->integer('company_id')->nullable();
				$table->integer('user_id')->nullable();
				$table->timestamps();
			});
		}
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('selected_dropdown');
    }
}
