<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateLastCloseYearTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('last_close_year')) {
			Schema::create('last_close_year', function (Blueprint $table) {
				$table->bigIncrements('id');
				$table->integer('last_close_year_id')->unsigned()->nullable();
				$table->integer('company_id')->unsigned()->nullable();
				$table->integer('opening_balance_id')->unsigned()->nullable();
				$table->integer('drawing_id')->unsigned()->nullable();
				$table->integer('user_id')->unsigned()->nullable();
				$table->timestamps();
			});
		}
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('last_close_year');
    }
}
