<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateLastYearTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('last_year')) {
			Schema::create('last_year', function (Blueprint $table) {
				$table->bigIncrements('id');
				$table->string('last_currency')->nullable();
				$table->string('current_currency')->nullable();
				$table->string('back_name')->nullable();
				$table->string('status')->nullable();
				$table->integer('company_id')->unsigned()->nullable();
				$table->integer('user_id')->unsigned()->nullable();
				$table->timestamps();
			});
		}
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('last_year');
    }
}
