<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCloseYearsEquityTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('close_years_equity')) {
        Schema::create('close_years_equity', function (Blueprint $table) {
            $table->bigIncrements('id');
			$table->integer('close_year_id')->unsigned();
			$table->integer('account_id')->unsigned();
			$table->integer('member_id')->unsigned()->nullable();
			$table->integer('last_percentage')->nullable();
			$table->integer('new_percentage')->nullable();
			$table->double('last_equity_amount')->nullable();
			$table->double('drawing_amount')->nullable();
			$table->double('new_equity_amount')->nullable();
			$table->integer('user_id')->unsigned()->nullable();
			$table->datetime('date')->nullable();
			$table->integer('company_id')->unsigned()->nullable();
            $table->text('description')->nullable();
			$table->string('status')->nullable();
            $table->timestamps();
        });
		}
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('close_years_equity');
    }
}
