<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCloseYearAccountsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('close_year_accounts')) {
        Schema::create('close_year_accounts', function (Blueprint $table) {
            $table->bigIncrements('id');
			$table->integer('close_year_id')->unsigned()->nullable();
			$table->integer('account_id')->unsigned();
			$table->integer('user_id')->unsigned()->nullable();
			$table->datetime('date')->nullable();
			$table->double('rate')->nullable();
			$table->double('amount')->nullable();
			$table->string('currency')->nullable();
			$table->integer('company_id')->unsigned()->nullable();
			$table->double('hq_rate')->nullable();
			$table->string('type')->nullable();
			$table->string('status')->nullable();
            $table->timestamps();
        });
		}
    }
	
    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('close_year_accounts');
    }
}
