<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCloseYearStocksTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {	
		if(!Schema::hasTable('close_year_stocks')) {
        Schema::create('close_year_stocks', function (Blueprint $table) {
            $table->bigIncrements('id');
			$table->integer('close_year_id')->unsigned()->nullable();
			$table->integer('inventory_id')->unsigned();
			$table->integer('inventory_site_id')->unsigned()->nullable();
			$table->datetime('date_in')->nullable();
			$table->double('qut_in')->nullable();
			$table->double('cost')->nullable();
			$table->string('code')->nullable();
			$table->double('widths')->nullable();
			$table->double('lengths')->nullable();
			$table->integer('user_id')->unsigned()->nullable();
			$table->double('other_measure')->nullable();
			$table->double('other_measure2')->nullable();
			$table->datetime('expire_date')->nullable();
			$table->double('khada')->nullable();
			$table->integer('company_id')->unsigned()->nullable();
			$table->string('image')->nullable();
			$table->integer('brand_id')->unsigned()->nullable();
			$table->string('location')->nullable();
			$table->double('price')->nullable();
			$table->string('superceed')->nullable();
            $table->text('description')->nullable();
			$table->string('status')->nullable();
            $table->timestamps();
        });
		}
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('close_year_stocks');
    }
}
