<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCloseYearsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('close_years')) {
        Schema::create('close_years', function (Blueprint $table) {
            $table->bigIncrements('id');
			$table->string('name');
			$table->datetime('close_date')->nullable();
			$table->datetime('opening_date')->nullable();
            $table->text('description')->nullable();
			$table->string('base_currency')->nullable();
			$table->integer('company_id')->unsigned()->nullable();
			$table->integer('sale_no')->nullable();
			$table->integer('purchase_no')->nullable();
			$table->integer('pay_no')->nullable();
			$table->integer('recive_no')->nullable();
			$table->integer('loan_no')->nullable();
			$table->integer('drawing_no')->nullable();
			$table->integer('build_no')->nullable();
			$table->integer('project_no')->nullable();
			$table->integer('contract_no')->nullable();
			$table->double('total_equity')->nullable();
			$table->double('total_income')->nullable();
			$table->string('status')->nullable();
			$table->string('equity_status')->nullable();
            $table->timestamps();
        });
		}
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('close_years');
    }
}
