<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProjectClosesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('project_closes')) {
			Schema::create('project_closes', function (Blueprint $table) {
				$table->bigIncrements('id');
				$table->integer('project_id')->unsigned();
				$table->integer('income_id')->unsigned();
                $table->integer('expense_id')->unsigned();
                $table->integer('owner_id')->unsigned();
                $table->text('description')->nullable();
                $table->datetime('date')->nullable();
				$table->timestamps();
			});
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('project_closes');
    }
}
