<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProjectShareholdersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('project_shareholders')) {
			Schema::create('project_shareholders', function (Blueprint $table) {
				$table->bigIncrements('id');
				$table->integer('project_id')->unsigned();
				$table->integer('shareholder_id')->unsigned();
				$table->double('percentage');
				$table->integer('company_id')->nullable();
				$table->timestamps();
			});
		}
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('project_shareholders');
    }
}
