<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateContractCloseDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('contract_close_details')) {
			Schema::create('contract_close_details', function (Blueprint $table) {
				$table->bigIncrements('id');
				$table->integer('contract_close_id')->unsigned();
				$table->integer('shareholder_id')->unsigned();
				$table->integer('income_transection_id')->unsigned();
                $table->integer('expense_transection_id')->unsigned();
                $table->integer('shareholder_transection_id')->unsigned();
				$table->double('percentage')->nullable();
				$table->timestamps();
			});
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('contract_close_details');
    }
}
