<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSaleTaxationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('sale_taxations')) {
            Schema::create('sale_taxations', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->integer('taxation_id')->unsigned()->nullable();
                $table->integer('sale_id')->unsigned()->nullable();
                $table->integer('sale_info_id')->unsigned()->nullable();
                $table->integer('vendor_id')->unsigned()->nullable();
                $table->integer('vendor_transaction_id')->unsigned()->nullable();
                $table->integer('customer_id')->unsigned()->nullable();
                $table->integer('customer_transaction_id')->unsigned()->nullable();
                $table->datetime('date')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sale_taxations');
    }
}
