<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddLoadTypeToFinedDriversTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('fined_drivers', function (Blueprint $table) {
            if (!Schema::hasColumn('fined_drivers','load_type')){
                $table->string('load_type')->nullable();
                $table->double('fined_quantity')->nullable();
                $table->double('load_quantity')->nullable();
				$table->integer('adjustment_id')->nullable();
				$table->integer('over_load_id')->nullable();
				$table->integer('vehicle_id')->nullable();
				
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('fined_drivers', function (Blueprint $table) {
            //
        });
    }
}
