<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateNewCustomReportsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('new_custom_reports')) {
            Schema::create('new_custom_reports', function (Blueprint $table) {
                $table->bigIncrements('id');
                 $table->string('part_name')->nullable();
                 $table->string('column_name')->nullable();
                 $table->integer('company_id')->unsigned()->nullable();
                 $table->integer('user_id')->unsigned()->nullable();
                $table->timestamps();
            });
        }


    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('new_custom_reports');
    }
}
