<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateLoadingDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('loading_details')) {

            Schema::create('loading_details', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->integer('loading_id')->unsigned();
                $table->integer('driver_id')->unsigned();
                $table->integer('vehicle_id')->unsigned();
                $table->string('source');
                $table->string('destination');
                $table->string('transit_number')->nullable();
                $table->integer('inventory_id')->unsigned();
                $table->integer('site_id')->unsigned()->comment('inventory_site_id');
                $table->integer('um_id')->unsigned()->comment('unit_measure_id');
                $table->double('item_quantity');
                $table->datetime('loading_date');
                $table->string('currency')->nullable();
                $table->double('rate')->nullable();
                $table->double('total_transfer_fee')->nullable();
                $table->string('cmr_number')->nullable();
                $table->integer('vehicle_location_id')->unsigned()->nullable();
                $table->integer('income_transaction_id')->unsigned()->nullable();
                $table->integer('asset_transaction_id')->unsigned()->nullable();
                $table->string('type')->nullable();
                $table->integer('type_id')->unsigned()->nullable();
       
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('loading_details');
    }
}
