<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateLoadingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('loadings')) {
            Schema::create('loadings', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->string('type')->comment('can be,purchase,sale,transer....');
                $table->integer('type_id')->unsigned()->comment('can be purchase_id,inventory_transfer_id ...');
                $table->string('description')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('loadings');
    }
}
