<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddGainOrLossTransactionIdToPaymentByFactorDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('payment_by_factor_details', function (Blueprint $table) {
             if (!Schema::hasColumn('payment_by_factor_details','gain_or_loss_transaction_id')){
                $table->integer('gain_or_loss_transaction_id')->unsigned()->nullable();
                $table->integer('gl_payable_id_transaction_id')->unsigned()->nullable()->comment('gl stands for gain or loss');
                 $table->double('today_rate')->nullable();
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('payment_by_factor_details', function (Blueprint $table) {
            //
        });
    }
}
