<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddGainOrLossTransactionIdToReceiveByFactorDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('receive_by_factor_details', function (Blueprint $table) {
            if (!Schema::hasColumn('receive_by_factor_details','gain_or_loss_transaction_id')){
                $table->integer('gain_or_loss_transaction_id')->unsigned()->nullable();
                $table->integer('gl_receivable_transaction_id')->unsigned()->nullable()->comment('gl stands for gain or loss');
                $table->double('today_rate')->nullable();
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('receive_by_factor_details', function (Blueprint $table) {
            //
        });
    }
}
