<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePaymentByFactorsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('payment_by_factors')) {
            Schema::create('payment_by_factors', function (Blueprint $table) {

            $table->bigIncrements('id');
            $table->integer('number')->unsigned();
            $table->string('ref_no')->nullable();
            $table->integer('member_id')->unsigned();
            $table->integer('company_id')->unsigned()->nullable();
            $table->datetime('date');
            $table->string('description')->nullable();
            $table->timestamps();
        
            });
        }

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('payment_by_factors');
    }
}
