<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateVehicleExpensesDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('vehicle_expenses_details')) {
            Schema::create('vehicle_expenses_details', function (Blueprint $table) {
                $table->bigIncrements('id');
				$table->integer('vehicle_expenses_id')->unsigned()->nullable();
                $table->double('amount')->nullable();
                $table->string('description')->nullable();
                $table->datetime('date')->nullable();
                $table->integer('company_id')->unsigned()->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('vehicle_expenses_details');
    }
}
