<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateVehicleFixDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('vehicle_fix_details')) {
            Schema::create('vehicle_fix_details', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->integer('vehicle_fix_id')->unsigned()->nullable();
                $table->integer('vehicle_equipment_id')->unsigned()->nullable();
                $table->string('name')->nullable();
                $table->string('description')->nullable();
                $table->integer('user_id')->unsigned()->nullable();
                $table->integer('company_id')->unsigned()->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('vehicle_fix_details');
    }
}
