<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateVehicleFixesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('vehicle_fixes')) {
            Schema::create('vehicle_fixes', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->integer('vehicle_id')->unsigned()->nullable();
                $table->integer('bank_transaction')->unsigned()->nullable();
                $table->integer('expense_transaction')->unsigned()->nullable();
                $table->datetime('date')->nullable();
                $table->string('type')->nullable();
                $table->string('description')->nullable();
                $table->integer('user_id')->unsigned()->nullable();
                $table->integer('company_id')->unsigned()->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('vehicle_fixes');
    }
}
