<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateVehicleLocationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('vehicle_locations')) {
            Schema::create('vehicle_locations', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->integer('driver_id')->unsigned()->nullable();
                $table->integer('vehicle_id')->unsigned()->nullable();
                $table->string('road')->nullable();
                $table->datetime('date')->nullable();
                $table->string('location')->nullable();
                $table->string('state')->nullable();
                $table->string('source')->nullable();
                $table->string('destination')->nullable();
                $table->string('description')->nullable();
                $table->integer('user_id')->unsigned()->nullable();
                $table->integer('company_id')->unsigned()->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('vehicle_locations');
    }
}
