<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateVehicleManagementsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('vehicle_managements')) {
            Schema::create('vehicle_managements', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->string('code')->nullable();
                $table->integer('customer_id')->unsigned()->nullable();
                $table->integer('driver_id')->unsigned()->nullable();
                $table->integer('car_id')->unsigned()->nullable();
                $table->integer('tanker_id')->unsigned()->nullable();
                $table->string('phone1')->nullable();
                $table->string('phone2')->nullable();
                $table->integer('location_id')->unsigned()->nullable();
                $table->double('qty')->nullable();
                $table->double('amount')->nullable();
                $table->string('currency')->nullable();
                $table->double('rate')->nullable();
                $table->integer('transaction_id')->unsigned()->nullable();
                $table->integer('income_transaction')->unsigned()->nullable();
                $table->datetime('date')->nullable();
                $table->datetime('project_start_date')->nullable();
                $table->datetime('project_end_date')->nullable();
                $table->string('state')->nullable();
                $table->string('description')->nullable();
                $table->integer('user_id')->unsigned()->nullable();
                $table->integer('company_id')->unsigned()->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('vehicle_managements');
    }
}
