<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateVehiclesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('vehicles')) {
            Schema::create('vehicles', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->string('vehicle_name')->nullable();
                $table->integer('vehicle_type_id')->unsigned()->nullable();
                $table->string('palet_number')->nullable();
                $table->string('tanker_number')->nullable();
                $table->integer('expense_id')->unsigned()->nullable();
                $table->integer('income_id')->unsigned()->nullable();
                $table->string('phone')->nullable();
                $table->string('chassis_number')->nullable();
                $table->string('engine_number')->nullable();
                $table->string('garlic_license_number')->nullable();
                $table->datetime('garlic_license_issue_date')->nullable();
                $table->datetime('garlic_license_end_date')->nullable();
                $table->string('build_company')->nullable();
                $table->string('model')->nullable();
                $table->string('build_year')->nullable();
                $table->string('type')->nullable();
                $table->string('color')->nullable();
                $table->string('description')->nullable();
                $table->integer('user_id')->unsigned()->nullable();
                $table->integer('company_id')->unsigned()->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('vehicles');
    }
}
