<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePriceLevelDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('price_level_details')) {
            Schema::create('price_level_details', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->integer('price_level_id')->unsigned();
                $table->integer('item_id')->unsigned();
                $table->double('rate');
                $table->integer('company_id')->unsigned()->nullable();
                $table->timestamps();
            });
        }

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('price_level_details');
    }
}
